/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.preferencesdialog;

import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.nooj4nlp.controller.preferencesdialog.UpdateTablesListener;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.gui.main.Launcher;

public class SelectDefLanguageActionListener
implements ActionListener {
    private JComboBox cbDefLanguage;
    private UpdateTablesListener tableListener;
    private JLabel lblLex;
    private JLabel lblSyn;
    private JLabel lNative;
    private JLabel lEnglish;
    private JLabel lChartVariants;

    public SelectDefLanguageActionListener(JComboBox cbDefLanguage, JLabel lblLex, JLabel lblSyn, JLabel lNative, JLabel lEnglish, JLabel lChartVariants, UpdateTablesListener tableListener) {
        this.cbDefLanguage = cbDefLanguage;
        this.tableListener = tableListener;
        this.lblLex = lblLex;
        this.lblSyn = lblSyn;
        this.lNative = lNative;
        this.lEnglish = lEnglish;
        this.lChartVariants = lChartVariants;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = this.cbDefLanguage.getSelectedIndex();
        if (index == -1) {
            return;
        }
        String isolanguagename = (String)this.cbDefLanguage.getSelectedItem();
        this.lblLex.setText("Lexical Resources for: " + isolanguagename);
        this.lblSyn.setText("Available Syntactic Resources for: " + isolanguagename);
        Language lan = new Language(isolanguagename);
        if (lan.rightToLeft) {
            this.lNative.setHorizontalAlignment(11);
            this.lNative.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        this.lNative.setText(lan.natName);
        this.lEnglish.setText(lan.engName);
        this.UpdateLvsFromPref(Launcher.projectMode, isolanguagename);
    }

    private void UpdateLvsFromPref(boolean projectmode, String languagename) {
        this.tableListener.GetAllResourcesFromDisk(projectmode, languagename);
        this.tableListener.GetAllResourcesFromPref(languagename);
    }
}

